########################
#  ONI TEAM ARENA 1.1  #
# AIRPORT BATTERY PACK #
########################
var int arena_area= 0; var int arena_players; var int arena_spawn_id;
var int arena_scoring;
################ ARENA STARTUP
func void main(void) 
{
	ArenaSetupLevel();
######## MISC SETUP
	chr_auto_aim_dist= 0; ui_suppress_prompt= 1;
#	ai2_showlinetochar= 1;
######## ADVANCED SETTINGS
	arena_menu= 0; chr_draw_all_characters= 0;
######## LAUNCH RANDOMIZER
	fork RandInit(); sleep 1;
######## LAUNCH GAME PROCESSES
	ArenaResetFlags(); ArenaResetWeapons(); ArenaResetScore();
	fork ArenaAreaInfo(); fork ArenaMusic();
	fork ArenaAdvanced(); fork ArenaSetupTeams(); 
}
######## RESPAWN LOGIC (CORE)
func void RespawnPlayer(int ai_id, string ai_team, string ai_name, string ai_nick) {
	if(chr_is_player(ai_name)) RandMusic();
	chr_invincible(ai_name, 1); chr_full_health(ai_name);
	fork SendToRandFlag(ai_id, ai_name, ai_team);
	chr_inv_reset(ai_name);
	fork GiveRandWeapon(ai_name);
	fork GiveRandPowerups(ai_name);
	ai2_idle(ai_name); ai2_setjobstate(ai_name);
	sleep 30; chr_invincible(ai_name, 0);
	ai2_setalert(ai_name, high); ai2_setmovementmode(ai_name, run);
	fork ArenaAwareness();

	chr_wait_health(ai_name, 1);
	if(arena_scoring) fork Death(ai_team, ai_name, ai_nick);
	if(arena_scoring and ai_name eq Mad_Spammer) {
# KILL THE BOMBER AND RESPAWN HIM WITH THE SAME ID
		chr_set_health(ai_name, 0);
		sleep 200; chr_draw_all_characters= 0;
		ai2_spawn(ai_name, force);
	}
else {
	chr_inv_reset(ai_name); chr_givepowerup(ai_name, invis, -1);
	chr_changeteam(ai_name, Switzerland);
	sleep 60; 
}
chr_changeteam(ai_name, ai_team);
	fork RespawnPlayer(ai_id, ai_team, ai_name, ai_nick);
}
func void AddPlayer(string ai_team, string ai_name, string ai_nick) {
	dmsg(ai_nick); dmsg("entered the arena");
	ai2_spawn(ai_name); chr_changeteam(ai_name, ai_team);
	ai2_neutralbehavior(ai_name, none)
#	ai2_passive(ai_name, 0); chr_neutral(ai_name, 0);
#	chr_freeze(ai_name, 0); ai2_active(ai_name);
#	chr_lock_active(ai_name);
	ai2_noncombatant(ai_name, 0); chr_unkillable(ai_name, 1);
	fork RespawnPlayer(arena_players, ai_team, ai_name, ai_nick);
	arena_players= arena_players + 1;
}
#################################### ARENA RESET
######## CYCLING AREAS (CUSTOM)
func ArenaAreaInfo {
	dmsg " "
	if(arena_area eq 0) dmsg "[b.ARENA 0] : [o.TERMINAL FUN]"
	if(arena_area eq 1) dmsg "[b.ARENA 1] : [b.HELLO HEAVEN]"
	if(arena_area eq 2) dmsg "[b.ARENA 2] : [g.JET LAG]"
	if(arena_area eq 3) dmsg "[b.ARENA 3] : [r.HIT & RUN]"
	if(arena_area eq 4) dmsg "[b.ARENA 4] : [y.HANDLE WITH CARE]"
	if(arena_area eq 5) dmsg "[b.ARENA 5] : [r.ZONE 451]"
	ArenaGunsInfo(); ArenaScoreInfo(); dmsg "FIGHT!"
}
######## KILLS EVERYBODY WITH AN ID GREATER THAN arena_spawn_id
func void ArenaKillPlayerSeq(void) {
	chr_health(arena_spawn_id, 1);
	sleep 1; arena_spawn_id= arena_spawn_id + 1;
	if(arena_spawn_id < arena_players) fork ArenaKillPlayerSeq();
}
######## ARENA RESET
func void ArenaReset(int next_area) {
	if(next_area) {
		dmsg " "
		arena_area= arena_area + 1;
#		if(arena_area eq 1) arena_area= 2;
#		if(arena_area eq 4) arena_area= 5;
		if(arena_area eq 6) arena_area= 0;
		fork ArenaAreaInfo();
	}
	fade_out(0, 0, 0, 50); arena_scoring= 0; sleep 50;
	ArenaResetLevel(); ArenaResetWeapons(); ArenaResetFlags(); sleep 1; chr_pin_character= 1
	arena_spawn_id= 0; fork ArenaKillPlayerSeq(); sleep 50; chr_pin_character= 0; fade_in(50);
	ArenaResetScore(); if(next_area) arena_scoring= 1;
}
