########################
#  ONI TEAM ARENA 1.1  #
# AIRPORT BATTERY PACK #
########################
################ FRAMES SINCE LAST RESTART
var int arena_time= 0;
################ RANDOM VARIABLES (CORE)
var int rand_cell= 0; var int rand_ammo= 0;
var int rand_invis= 0; var int rand_shield= 0;
var int rand_dead= 0; var int rand_weapon= 0;
var int rand_flag1= 0; var int rand_flag2= 0;
var int rand_music= 0;
################ THEIR MAX VALUES (CUSTOM)
######## POWERUPS, WEAPONS AND DEATH MESSAGES (LEVEL-INDEPENDENT)
var int rand_cell_max= 6; var int rand_ammo_max= 7;
var int rand_invis_max= 98; var int rand_shield_max= 99;
var int rand_dead_max= 22; var int rand_weapon_max= 14;
######## TELEPORT FLAG (LEVEL- AND AREA-DEPENDENT)
var int rand_flag1_max= 10; var int rand_flag2_max= 11;
######## MUSIC (LEVEL-DEPENDENT)
var int rand_music_max= 2;
################ AUXILIARY VARIABLES (CORE)
var string now_playing; var string next_tune;
var string rand_weapon_name;
###################################################################
################ JUKEBOX (CORE)
func void ArenaMusic(void) {
	if(next_tune ne now_playing) {
		sound_music_stop(now_playing); now_playing= next_tune; 
		sleep 400; sound_music_start(now_playing);
	}
	sleep 4000; fork ArenaMusic();
}
################ RANDOMIZER INITIALIZATION (CUSTOM, AREA-SPECIFIC)
func void RandInit(void) {
	rand_cell_max= 6; rand_shield_max= 99;
	rand_ammo_max= 7; rand_invis_max= 98;
	rand_dead_max= 22; rand_weapon_max= 14;
	rand_music_max= 3; ArenaResetFlags();

	now_playing= atm_gr06; next_tune= mus_fitec_hd;
	rand_weapon_name= w6_vdg;
	fork RandGen();
}
func ArenaResetFlags {
	if(arena_area eq 0) {rand_flag1_max= 6; rand_flag2_max= 7;}
	if(arena_area eq 1) {rand_flag1_max= 3; rand_flag2_max= 4;}
	if(arena_area eq 2) {rand_flag1_max= 7; rand_flag2_max= 8;}
	if(arena_area eq 3) {rand_flag1_max= 1; rand_flag2_max= 2;}
	if(arena_area eq 4) {rand_flag1_max= 3; rand_flag2_max= 4;}
	if(arena_area eq 5) {rand_flag1_max= 1; rand_flag2_max= 2;}
}
################ RANDOM NUMBER GENERATOR (CORE)
func void RandGen(void) {
	rand_cell= rand_cell + 1; if(rand_cell > rand_cell_max) rand_cell= 0;
	rand_ammo= rand_ammo + 1; if(rand_ammo > rand_ammo_max) rand_ammo= 0;
	rand_invis= rand_invis + 1; if(rand_invis > rand_invis_max) rand_invis= 0;
	rand_shield= rand_shield + 1; if(rand_shield > rand_shield_max) rand_shield= 0;
	rand_dead= rand_dead + 1; if(rand_dead > rand_dead_max) rand_dead= 0;
	rand_weapon= rand_weapon + 1; if(rand_weapon > rand_weapon_max) rand_weapon= 0
	rand_flag1= rand_flag1 + 1; if(rand_flag1 > rand_flag1_max) rand_flag1= 0;
	rand_flag2= rand_flag2 + 1; if(rand_flag2 > rand_flag2_max) rand_flag2= 0;
	rand_music= rand_music + 1; if(rand_music > rand_music_max) rand_music= 0;

	arena_time= arena_time + 1;
	if(arena_limit eq 1 and arena_time eq 9600) sound_ambient_start alarm_loop
	if(arena_limit eq 2 and arena_time eq 16800) sound_ambient_start alarm_loop
	sleep 1; fork RandGen();
}
################ CLIENT FUNCTIONS (CUSTOM)
######## POWERUPS (LEVEL-INDEPENDENT)
func void GiveRandPowerups(string ai_name) {
	if(rand_shield > 95) chr_givepowerup(ai_name, shield);
	if(rand_invis  > 95) chr_givepowerup(ai_name, invis);
	chr_givepowerup(ai_name, cell, rand_cell);
	chr_givepowerup(ai_name, ammo, rand_ammo);
}
######## MUSIC FILES (LEVEL-DEPENDENT)
func void RandMusic(void) {
	if(rand_music eq 0) next_tune= mus_fitec_hd;
	if(rand_music eq 1) next_tune= mus_asian;
	if(rand_music eq 2) next_tune= atm_gr06;
}
######## WEAPONS (LEVEL-INDEPENDENT)
func void RandWeapon(void) {
	if(rand_weapon eq  0) rand_weapon_name=  w6_vdg;
	if(rand_weapon eq  1) rand_weapon_name=  w3_phr;
	if(rand_weapon eq  2) rand_weapon_name=  w7_scc;
	if(rand_weapon eq  3) rand_weapon_name=  w1_tap;
	if(rand_weapon eq  4) rand_weapon_name=  w2_sap;
	if(rand_weapon eq  5) rand_weapon_name=  w3_phr;
	if(rand_weapon eq  6) rand_weapon_name=  w4_psm;
	if(rand_weapon eq  7) rand_weapon_name=  w5_sbg;
	if(rand_weapon eq  8) rand_weapon_name=  w6_vdg;
	if(rand_weapon eq  9) rand_weapon_name=  w7_scc;
	if(rand_weapon eq 10) rand_weapon_name=  w8_mbo;
	if(rand_weapon eq 11) rand_weapon_name=  w9_scr;
	if(rand_weapon eq 12) rand_weapon_name=  w8_mbo;
	if(rand_weapon eq 13) rand_weapon_name= w11_ba1;
	if(rand_weapon eq 14) rand_weapon_name=  w4_psm;
}
######## TELEPORT FLAGS (LEVEL- AND AREA-DEPENDENT)
func void SendToRandFlag(int ai_id, string ai_name, string ai_team) {
	if(ai_team ne Konoko and ai_team ne Syndicate) {
		if(rand_flag1 > rand_flag2) ai_team= Konoko
		else                     ai_team= Syndicate
	}
################ TERMINAL FUN
	if(arena_area eq 0) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_teleport(ai_name,  110); chr_facetoflag(ai_name,  110);}
			if(rand_flag1 eq 1)
				{chr_teleport(ai_name, 1027); chr_facetoflag(ai_name, 1027);}
			if(rand_flag1 eq 2)
				{chr_teleport(ai_name, 1028); chr_facetoflag(ai_name, 1028);}
			if(rand_flag1 eq 3)
				{chr_teleport(ai_name, 1030); chr_facetoflag(ai_name, 1030);}
			if(rand_flag1 eq 4)
				{chr_teleport(ai_name, 1031); chr_facetoflag(ai_name, 1031);}
			if(rand_flag1 eq 5)
				{chr_teleport(ai_name, 1032); chr_facetoflag(ai_name, 1032);}
			if(rand_flag1 >  5)
				{chr_teleport(ai_name, 1033); chr_facetoflag(ai_name, 1033);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq  0)
				{chr_teleport(ai_name, 7003); chr_facetoflag(ai_name, 7003);}
			if(rand_flag2 eq  1)
				{chr_teleport(ai_name, 7004); chr_facetoflag(ai_name, 7004);}
			if(rand_flag2 eq  2)
				{chr_teleport(ai_name, 7034); chr_facetoflag(ai_name, 7034);}
			if(rand_flag2 eq  3)
				{chr_teleport(ai_name, 7035); chr_facetoflag(ai_name, 7035);}
			if(rand_flag2 eq  4)
				{chr_teleport(ai_name, 7036); chr_facetoflag(ai_name, 7036);}
			if(rand_flag2 eq  5)
				{chr_teleport(ai_name, 7037); chr_facetoflag(ai_name, 7037);}
			if(rand_flag2 >   5)
				{chr_teleport(ai_name, 7040); chr_facetoflag(ai_name, 7040);}
		}
	}
################ PALE SHELTER
	if(arena_area eq 1) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_location(ai_id, -250, -60, -1750);}
			if(rand_flag1 eq 1)
				{chr_location(ai_id, -250, -60, -1680);}
			if(rand_flag1 eq 2)
				{chr_location(ai_id, -200, -60, -1750);}
			if(rand_flag1 >  2)
				{chr_location(ai_id, -200, -60, -1680);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq 0)
				{chr_location(ai_id, -150, -60, -1750);}
			if(rand_flag2 eq 1)
				{chr_location(ai_id, -150, -60, -1680);}
			if(rand_flag2 eq 2)
				{chr_location(ai_id, -100, -60, -1750);}
			if(rand_flag2 > 2)
				{chr_location(ai_id, -100, -60, -1680);}
		}
	}
	if(arena_area eq 11) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_location(ai_id, 0, -60, -1000);}
			if(rand_flag1 eq 1)
				{chr_location(ai_id, 0, -60, -1200);}
			if(rand_flag1 eq 2)
				{chr_location(ai_id, 0, -60, -1400);}
			if(rand_flag1 >  2)
				{chr_location(ai_id, 200, -60, -1000);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq 0)
				{chr_location(ai_id, 200, -60, -1200);}
			if(rand_flag2 eq 1)
				{chr_location(ai_id, 200, -60, -1400);}
			if(rand_flag2 eq 2)
				{chr_location(ai_id, 400, -60, -1000);}
			if(rand_flag2 eq 3)
				{chr_location(ai_id, 400, -60, -1200);}
			if(rand_flag2 >  3)
				{chr_location(ai_id, 400, -60, -1400);}
		}
	}
	if(arena_area eq 10) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_teleport(ai_name, 1116); chr_facetoflag(ai_name, 1116);}
			if(rand_flag1 eq 1)
				{chr_teleport(ai_name, 1117); chr_facetoflag(ai_name, 1117);}
			if(rand_flag1 eq 2)
				{chr_teleport(ai_name, 1118); chr_facetoflag(ai_name, 1118);}
			if(rand_flag1 eq 3)
				{chr_teleport(ai_name, 1119); chr_facetoflag(ai_name, 1119);}
			if(rand_flag1 eq 4)
				{chr_teleport(ai_name, 1120); chr_facetoflag(ai_name, 1120);}
			if(rand_flag1 eq 5)
				{chr_teleport(ai_name, 1121); chr_facetoflag(ai_name, 1121);}
			if(rand_flag1 eq 6)
				{chr_teleport(ai_name, 1122); chr_facetoflag(ai_name, 1122);}
			if(rand_flag1 eq 7)
				{chr_teleport(ai_name, 1123); chr_facetoflag(ai_name, 1123);}
			if(rand_flag1 eq 8)
				{chr_teleport(ai_name, 1124); chr_facetoflag(ai_name, 9524);}
			if(rand_flag1 eq 9)
				{chr_teleport(ai_name, 1125); chr_facetoflag(ai_name, 9525);}
			if(rand_flag1 eq 10)
				{chr_teleport(ai_name, 1126); chr_facetoflag(ai_name, 9526);}
			if(rand_flag1 eq 11)
				{chr_teleport(ai_name, 1127); chr_facetoflag(ai_name, 1127);}
			if(rand_flag1 eq 12)
				{chr_teleport(ai_name, 1128); chr_facetoflag(ai_name, 1128);}
			if(rand_flag1 eq 13)
				{chr_teleport(ai_name, 1129); chr_facetoflag(ai_name, 1129);}
			if(rand_flag1 >  13)
				{chr_teleport(ai_name, 1130); chr_facetoflag(ai_name, 1130);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq  0)
				{chr_teleport(ai_name, 1131); chr_facetoflag(ai_name, 1131);}
			if(rand_flag2 eq  1)
				{chr_teleport(ai_name, 1141); chr_facetoflag(ai_name, 1141);}
			if(rand_flag2 eq  2)
				{chr_teleport(ai_name, 7023); chr_facetoflag(ai_name, 7023);}
			if(rand_flag2 eq  3)
				{chr_teleport(ai_name, 7024); chr_facetoflag(ai_name, 7024);}
			if(rand_flag2 eq  4)
				{chr_teleport(ai_name, 7025); chr_facetoflag(ai_name, 7025);}
			if(rand_flag2 eq  5)
				{chr_teleport(ai_name, 7026); chr_facetoflag(ai_name, 7026);}
			if(rand_flag2 eq  6)
				{chr_teleport(ai_name, 7027); chr_facetoflag(ai_name, 7027);}
			if(rand_flag2 eq  7)
				{chr_teleport(ai_name, 7028); chr_facetoflag(ai_name, 7028);}
			if(rand_flag2 eq  8)
				{chr_teleport(ai_name, 7029); chr_facetoflag(ai_name, 7029);}
			if(rand_flag2 eq  9)
				{chr_teleport(ai_name, 7030); chr_facetoflag(ai_name, 7030);}
			if(rand_flag2 eq 10)
				{chr_teleport(ai_name, 7052); chr_facetoflag(ai_name, 7052);}
			if(rand_flag2 eq 11)
				{chr_teleport(ai_name, 7059); chr_facetoflag(ai_name, 7059);}
			if(rand_flag2 eq 12)
				{chr_teleport(ai_name, 7060); chr_facetoflag(ai_name, 7060);}
			if(rand_flag2 eq 13)
				{chr_teleport(ai_name, 7061); chr_facetoflag(ai_name, 7061);}
			if(rand_flag2 eq 14)
				{chr_teleport(ai_name, 7062); chr_facetoflag(ai_name, 7062);}
			if(rand_flag2 >  14)
				{chr_teleport(ai_name, 7069); chr_facetoflag(ai_name, 7069);}
		}
	}
################ JET LAG
	if(arena_area eq 2) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_teleport(ai_name, 1020); chr_facetoflag(ai_name, 1020);}
			if(rand_flag1 eq 1)
				{chr_teleport(ai_name, 1021); chr_facetoflag(ai_name, 1021);}
			if(rand_flag1 eq 2)
				{chr_teleport(ai_name, 1022); chr_facetoflag(ai_name, 1022);}
			if(rand_flag1 eq 3)
				{chr_teleport(ai_name, 1023); chr_facetoflag(ai_name, 1023);}
			if(rand_flag1 eq 4)
				{chr_teleport(ai_name, 1136); chr_facetoflag(ai_name, 1136);}
			if(rand_flag1 eq 5)
				{chr_teleport(ai_name, 7002); chr_facetoflag(ai_name, 7002);}
			if(rand_flag1 eq 6)
				{chr_teleport(ai_name, 7011); chr_facetoflag(ai_name, 7011);}
			if(rand_flag1 >  6)
				{chr_teleport(ai_name, 7018); chr_facetoflag(ai_name, 7018);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq  0)
				{chr_teleport(ai_name, 7021); chr_facetoflag(ai_name, 7021);}
			if(rand_flag2 eq  1)
				{chr_teleport(ai_name, 7022); chr_facetoflag(ai_name, 7022);}
			if(rand_flag2 eq  2)
				{chr_teleport(ai_name, 7038); chr_facetoflag(ai_name, 7038);}
			if(rand_flag2 eq  3)
				{chr_teleport(ai_name, 7041); chr_facetoflag(ai_name, 7041);}
			if(rand_flag2 eq  4)
				{chr_teleport(ai_name, 7042); chr_facetoflag(ai_name, 7042);}
			if(rand_flag2 eq  5)
				{chr_teleport(ai_name, 7043); chr_facetoflag(ai_name, 7043);}
			if(rand_flag2 eq  6)
				{chr_teleport(ai_name, 7044); chr_facetoflag(ai_name, 7044);}
			if(rand_flag2 >   6)
				{chr_teleport(ai_name, 7045); chr_facetoflag(ai_name, 7045);}
		}
	}
################ HIT & RUN
	if(arena_area eq 3) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_facetoflag(ai_name,  101); chr_teleport(ai_name,  101);}
			if(rand_flag1 >  0)
				{chr_facetoflag(ai_name,  102); chr_teleport(ai_name,  102);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq 0)
				{chr_facetoflag(ai_name, 1017); chr_teleport(ai_name, 1017);}
			if(rand_flag2 eq 1)
				{chr_facetoflag(ai_name, 7000); chr_teleport(ai_name, 7000);}
			if(rand_flag2 >  1)
				{chr_facetoflag(ai_name, 7014); chr_teleport(ai_name, 7014);}
		}
	}
################ FRAGILE
	if(arena_area eq 4) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_location(ai_id, -100, -60, 1500);}
			if(rand_flag1 eq 1)
				{chr_location(ai_id, -200, -60, 1500);}
			if(rand_flag1 eq 2)
				{chr_location(ai_id, -300, -60, 1500);}
			if(rand_flag1 >  2)
				{chr_location(ai_id, -400, -60, 1500);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq 0)
				{chr_location(ai_id, -400, -60, 1700);}
			if(rand_flag2 eq 1)
				{chr_location(ai_id, -300, -60, 1700);}
			if(rand_flag2 eq 2)
				{chr_location(ai_id, -200, -60, 1700);}
			if(rand_flag2 eq 3)
				{chr_location(ai_id, -100, -60, 1700);}
			if(rand_flag2 >  3)
				{chr_location(ai_id, 0, -60, 1700);}
		}
	}
	if(arena_area eq 41) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_location(ai_id, -150, -60, 0);}
			if(rand_flag1 eq 1)
				{chr_location(ai_id, -150, -60, 0);}
			if(rand_flag1 eq 2)
				{chr_location(ai_id, -150, -60, 0);}
			if(rand_flag1 >  2)
				{chr_location(ai_id, -250, -60, 200);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq 0)
				{chr_location(ai_id, -250, -60, 200);}
			if(rand_flag2 eq 1)
				{chr_location(ai_id, -250, -60, 200);}
			if(rand_flag2 eq 2)
				{chr_location(ai_id, -350, -60, 400);}
			if(rand_flag2 eq 3)
				{chr_location(ai_id, -350, -60, 400);}
			if(rand_flag2 >  3)
				{chr_location(ai_id, -350, -60, 400);}
		}
	}
	if(arena_area eq 40) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_facetoflag(ai_name, 1101); chr_teleport(ai_name, 1101);}
			if(rand_flag1 eq 1)
				{chr_facetoflag(ai_name, 1102); chr_teleport(ai_name, 1102);}
			if(rand_flag1 eq 2)
				{chr_facetoflag(ai_name, 1109); chr_teleport(ai_name, 1109);}
			if(rand_flag1 >  2)
				{chr_facetoflag(ai_name, 7007); chr_teleport(ai_name, 7007);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq 0)
				{chr_facetoflag(ai_name, 7057); chr_teleport(ai_name, 7057);}
			if(rand_flag2 eq 1)
				{chr_facetoflag(ai_name, 7058); chr_teleport(ai_name, 7058);}
			if(rand_flag2 eq 2)
				{chr_facetoflag(ai_name, 7063); chr_teleport(ai_name, 7063);}
			if(rand_flag2 >  2)
				{chr_facetoflag(ai_name, 7064); chr_teleport(ai_name, 7064);}
		}
	}
################ ZONE 451
	if(arena_area eq 5) {
		if(ai_team eq Konoko) {
			if(rand_flag1 eq 0)
				{chr_facetoflag(ai_name, 1015); chr_teleport(ai_name, 1015);}
			if(rand_flag1 >  0)
				{chr_facetoflag(ai_name, 7006); chr_teleport(ai_name, 7006);}
		}
		if(ai_team eq Syndicate) {
			if(rand_flag2 eq 0)
				{chr_facetoflag(ai_name, 7050); chr_teleport(ai_name, 7050);}
			if(rand_flag2 >  0)
				{chr_facetoflag(ai_name, 7051); chr_teleport(ai_name, 7051);}
		}
	}
################ HEAVEN ELEVEN
	chr_animate(ai_name, KONCOMsuper_kick);
}
######## DEATH MESSAGES (LEVEL-INDEPENDENT)
func RandDead {
	if(rand_dead eq  0) dmsg "is dead"
	if(rand_dead eq  1) dmsg "is no more"
	if(rand_dead eq  2) dmsg "has ceased to be"
	if(rand_dead eq  3) dmsg "has expired"
	if(rand_dead eq  4) dmsg "is history"
	if(rand_dead eq  5) dmsg "has been neutralized"
	if(rand_dead eq  6) dmsg "has been annihilated"
	if(rand_dead eq  7) dmsg "has died"
	if(rand_dead eq  8) dmsg "has turned to dust"
	if(rand_dead eq  9) dmsg "has bitten the dust"
	if(rand_dead eq 10) dmsg "has gone"
	if(rand_dead eq 11) dmsg "will come back"
	if(rand_dead eq 12) dmsg "has been obliterated"
	if(rand_dead eq 13) dmsg "has been destroyed"
	if(rand_dead eq 14) dmsg "has been wiped out"
	if(rand_dead eq 15) dmsg "is a stiff"
	if(rand_dead eq 16) dmsg "has passed on"
	if(rand_dead eq 17) dmsg "has been destroyed"
	if(rand_dead eq 18) dmsg "is late"
	if(rand_dead eq 19) dmsg "rests in peace"
	if(rand_dead eq 20) dmsg "is bereft of life"
	if(rand_dead eq 21) dmsg "is deceased"
	if(rand_dead eq 22) dmsg "is demised"
	if(rand_dead >  22) dmsg "is dead"
}
